<?=$this->extend('layouts/selector_main')?>

<?=$this->section('content')?>
    <div class="container-fluid" id="maindiv">
        <div class="row">
            <div class="col-12 col-md-3 d-flex align-items-center left-gutter bg-dark-blue">
                <div class="container-fluid ">
					<div class="row">
						<div class="col-12">
							<h4 class="fs-2 text-yellow-light">Solar, customized.</h4>
						</div>
						<div class="col-12">
							<p class="fs-6 text-white">
                                Answer a few basic questions and we'll start designing your system to match you.
                            </p>
						</div>
                        <div class="col-12 pt-5 call-number">
							<p class="fs-6 text-white mb-0">
                                Want to speak to a solar advisor?</br>
                                <i class="fas fa-phone-alt"></i>
                                <a class="text-white" href="tel:833-378-8426">833-378-8426 </a>
                            </p>
						</div>
					</div>
				</div>
            </div>
            <div class="col-12 col-md-6 offset-md-3 d-flex justify-content-center align-items-center py-5">
                <div class="container pt-5">
                    <div class="row pt-5">
                        <form id="regForm" method="POST" class="needs-validation" action="selector/save_user" novalidate autocomplete="off">
 
                            <!-- One "tab" for each step in the form: -->
                            <div class="form-tab">
                                <h3 class="fs-3">We are excited to learn more about your home</h3>
                                <div class="row mb-4 d-flex justify-content-center align-items-center">
                                    <div class="col-12 col-md-4 mx-1 py-2">
                                        <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-radio">  
                                            <svg class="w-50 h-50 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" >
                                                <path d="M81.112 23.202h-.802l-7.517-20.24A4.564 4.564 0 0068.533 0H15.467a4.564 4.564 0 00-4.26 2.963L3.69 23.202h-.802A2.891 2.891 0 000 26.09v2.32a2.891 2.891 0 002.888 2.888h.427v26.97a1.23 1.23 0 102.46 0v-26.97h19.32a4.021 4.021 0 002.863-1.186L42 16.07l14.042 14.042a4.02 4.02 0 002.863 1.186h19.32v3.262a1.23 1.23 0 102.46 0v-3.263h.427A2.891 2.891 0 0084 28.41v-2.32a2.891 2.891 0 00-2.888-2.888zM13.515 3.819a2.093 2.093 0 011.953-1.358h53.064c.867 0 1.652.546 1.954 1.358l7.2 19.383H60.58L44.863 7.483A4.021 4.021 0 0042 6.298a4.02 4.02 0 00-2.862 1.185L23.42 23.202H6.315l7.2-19.383zm68.024 24.59a.427.427 0 01-.427.428H58.905c-.424 0-.823-.165-1.123-.465L42.87 13.46a1.23 1.23 0 00-1.74 0L26.218 28.372c-.3.3-.698.465-1.122.465H2.889a.427.427 0 01-.427-.427v-2.32c0-.236.191-.427.427-.427h21.04c.327 0 .64-.13.87-.36l16.08-16.08c.3-.3.698-.464 1.122-.464.424 0 .822.165 1.122.464l16.079 16.08c.23.23.544.36.87.36h21.04c.236 0 .427.191.427.427v2.32z"></path>
                                                <path d="M73.986 65.438c.68 0 1.23-.552 1.23-1.231V42.331c0-.68-.55-1.23-1.23-1.23H57.413c-.68 0-1.23.55-1.23 1.23v21.876c0 .68.55 1.23 1.23 1.23h16.573zm-1.23-7.765H66.93v-5.825h5.825v5.825zm-8.287 0h-5.825v-5.825h5.825v5.825zm8.287 5.303H58.643v-2.842h14.111v2.843zm0-13.59H66.93v-5.825h5.825v5.826zm-8.287-5.825v5.826h-5.825v-5.825h5.825zM26.587 65.438c.68 0 1.231-.552 1.231-1.231V42.331c0-.68-.55-1.23-1.23-1.23H10.014c-.68 0-1.23.55-1.23 1.23v21.876c0 .68.55 1.23 1.23 1.23h16.572zm-1.23-7.765h-5.825v-5.825h5.825v5.825zm-8.286 0h-5.826v-5.825h5.826v5.825zm8.286 5.303H11.245v-2.842h14.112v2.843zm0-13.59h-5.825v-5.825h5.825v5.826zm-8.286-5.825v5.826h-5.826v-5.825h5.826zM45.978 46.404h-7.955c-.68 0-1.23.55-1.23 1.23v5.303c0 .68.55 1.231 1.23 1.231h7.955c.68 0 1.23-.551 1.23-1.23v-5.304c0-.68-.55-1.23-1.23-1.23zm-1.23 5.303h-5.495v-2.842h5.494v2.842zM48.534 30.895a6.541 6.541 0 00-6.533-6.533 6.541 6.541 0 00-6.534 6.534A6.541 6.541 0 0042 37.428a6.541 6.541 0 006.533-6.534zm-10.606 0A4.078 4.078 0 0142 26.823a4.078 4.078 0 014.072 4.072 4.078 4.078 0 01-4.072 4.073 4.078 4.078 0 01-4.073-4.073z"></path>
                                                <path d="M82.77 67.285h-2.085v-26.97a1.23 1.23 0 10-2.46 0v26.97H52.511V42.331c0-.68-.551-1.23-1.23-1.23H32.72c-.68 0-1.23.55-1.23 1.23v24.954H5.775v-3.262a1.23 1.23 0 10-2.46 0v3.263H1.23c-.68 0-1.23.55-1.23 1.23v5.635c0 .68.55 1.23 1.23 1.23H82.77c.68 0 1.23-.55 1.23-1.23v-5.635c0-.68-.55-1.23-1.23-1.23zm-48.82-8.974h1.753a1.23 1.23 0 100-2.46H33.95V43.56h16.1v23.724h-16.1v-8.974zm47.589 14.61H2.462v-3.175h79.077v3.174z"></path>
                                            </svg>
                                            <p class="col-12"> Home Owner</p>
                                            <div class="col-12">
                                                <input type="radio" class="form-check-input with-gap" name="homeown" value="homeowner" checked>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-4 mx-1 py-2">
                                        <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-radio" onclick="openNav()">  
                                            <svg class="w-50 h-50 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" >
                                                <path d="M66.484 34.696H55.705V1.424C55.705.637 55.027 0 54.19 0H2.48C1.64 0 .961.637.961 1.424v81.152c0 .787.68 1.424 1.516 1.424h64.006c.837 0 1.516-.638 1.516-1.424V36.12c0-.786-.679-1.424-1.516-1.424zm-54.41 1.424v45.033h-8.08V2.847h48.68v31.85H13.59c-.837 0-1.516.637-1.516 1.423zm26.44 45.033H24.87V68.01h13.644v13.142zm16.676 0H41.546V68.01H55.19v13.142zm2.986 0V66.588c0-.786-.678-1.424-1.516-1.424H23.416c-.838 0-1.517.638-1.517 1.424v14.565h-6.791v-43.61h49.861l.046 43.61h-6.837z"></path>
                                                <path d="M43.805 6.008h-8.626c-.838 0-1.516.637-1.516 1.424v8.086c0 .787.678 1.424 1.516 1.424h8.61c.838 0 1.517-.637 1.517-1.424V7.432c0-.781-.67-1.416-1.501-1.424zm-7.11 8.087v-5.24h5.578l.016 5.24h-5.594zM21.05 6.008h-8.612c-.837 0-1.516.637-1.516 1.424v8.086c0 .787.68 1.424 1.516 1.424h8.611c.838 0 1.516-.637 1.516-1.424V7.432c0-.787-.678-1.424-1.516-1.424zm-1.517 8.087h-5.579v-5.24h5.58v5.24zM43.805 20.644h-8.626c-.838 0-1.516.638-1.516 1.424v8.115c0 .786.678 1.424 1.516 1.424h8.61c.838 0 1.517-.638 1.517-1.424v-8.115c0-.781-.67-1.416-1.501-1.424zm-7.11 8.087v-5.24h5.578l.016 5.24h-5.594zM21.05 20.644h-8.612c-.837 0-1.516.638-1.516 1.424v8.115c0 .786.68 1.424 1.516 1.424h8.611c.838 0 1.516-.638 1.516-1.424v-8.115c0-.787-.678-1.424-1.516-1.424zm-1.517 8.087h-5.579v-5.24h5.58v5.24zM55.706 39.509h-8.611c-.838 0-1.516.637-1.516 1.423v8.087c0 .787.678 1.424 1.516 1.424h8.61c.838 0 1.517-.637 1.517-1.424v-8.087c0-.786-.68-1.423-1.517-1.423zm-1.517 8.087h-5.578v-5.24h5.579v5.24zM32.965 39.509h-8.61c-.838 0-1.517.637-1.517 1.423v8.087c0 .787.68 1.424 1.516 1.424h8.611c.837 0 1.516-.637 1.516-1.424v-8.087c0-.786-.678-1.423-1.516-1.423zm-1.516 8.087H25.87v-5.24h5.58v5.24zM55.706 52.65h-8.611c-.838 0-1.516.637-1.516 1.423v8.087c0 .786.678 1.424 1.516 1.424h8.61c.838 0 1.517-.638 1.517-1.424v-8.087c0-.786-.68-1.424-1.517-1.424zm-1.517 8.086h-5.578v-5.24h5.579v5.24zM32.965 52.65h-8.61c-.838 0-1.517.637-1.517 1.423v8.087c0 .786.68 1.424 1.516 1.424h8.611c.837 0 1.516-.638 1.516-1.424v-8.087c0-.786-.678-1.424-1.516-1.424zm-1.516 8.086H25.87v-5.24h5.58v5.24z"></path>
                                            </svg>
                                            <p class="col-12"> Renter</p>
                                            <div class="col-12">
                                                <input type="radio" class="form-check-input with-gap" name="homeown" value="renter" required> 
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mb-4 d-flex justify-content-center align-items-center">
                                    <div class="form-outline col-12 col-md-8">
											<input type="text" id="address_input" class="form-control" id="address_input" name="address" required/>
											<label class="form-label" for="address_input">Address*</label>
                                            <div class="invalid-feedback mt-1">Address is required.</div>
									</div>
                                </div>

                                <div class="row mb-4 d-flex justify-content-center align-items-center my-5">
                                    <div class="form-outline col-12 col-md-4 mx-1 my-4">
											<input type="number" id="home_size" name="home_size" class="form-control" min="0" max="9999"required/>
											<label class="form-label" for="home_size">Home Size*</label>
                                            <div class="invalid-feedback mt-1">Home Size is required.</div>
									</div>

                                    <div class="col-12 col-md-4 mx-1 px-0">
                                        <div class="select">
                                            <select class="select-text form-control select-input" id="home_type" name="home-type" required>
                                                <option value="" disabled selected></option>
                                                <option value="Single Family" >Single Family</option>
                                                <option value="Condo">Condo</option>
                                                <option value="Rental Property">Rental Property</option>
                                                <option value="Mobile Home">Mobile Home</option>
                                            </select>
                                            <span class="select-highlight"></span>
                                            <span class="select-bar"></span>
                                            <label class="select-label">Home Type</label>
                                            <div class="invalid-feedback mt-1">Home Type is required.</div>
                                        </div>
                                       
                                    </div>
                                </div>

                                <div class="row mb-4 d-flex justify-content-center align-items-center my-5">
                                    <div class="col-12 col-md-8 mx-1 py-2">
                                        <h3 class="fs-4">*Do you currently have solar panels on your roof?</h3>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3 checker-box-radio">  
                                            <div class="col-12 form-check">
                                                <input type="radio" class="form-check-input with-gap" id="solarpanel" name="solarpanel" value="no" checked  required>
                                                <label class="form-check-label" for="solarpanel">
                                                   No
                                                </label>
                                            </div>
                                          
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-radio" onclick="openNavSolar()">  
                                            <div class="col-12 form-check  ">
                                                <input type="radio" class="form-check-input with-gap" id="solarpanel2" value="yes" name="solarpanel">
                                                <label class="form-check-label" for="solarpanel2">
                                                   Yes
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mb-4 d-flex justify-content-center align-items-center">
                                    <div class="col-12 text-center">
                                        <h3 class="fs-4 ">*What is your Roof Pitch?<span style="font-size:30px;cursor:pointer" onclick="openRoofPitchSideNav()"> <i class="fas fa-info-circle fa-sm"></i></span></h3>
                                    </div>
                                    <div class="col-12 col-md-2 mx-1 py-2">
                                        <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-radio">  
                                            <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" >
                                            <path d="M84.398 58.754H68.111V33.05h20.73c.392 0 .769-.193 1.046-.537.278-.345.434-.812.434-1.299V1.836c0-.487-.156-.954-.434-1.298C89.61.193 89.233 0 88.84 0H2.961c-.392 0-.769.193-1.047.538a2.08 2.08 0 00-.433 1.298v29.377c0 .487.156.954.433 1.299.278.344.655.537 1.047.537h5.923v25.705H1.481c-.393 0-.77.194-1.047.538A2.08 2.08 0 000 60.59c0 .487.156.954.434 1.299.277.344.654.537 1.047.537h82.917c.393 0 .77-.193 1.047-.537a2.08 2.08 0 00.434-1.299c0-.487-.156-.954-.434-1.298-.277-.344-.654-.538-1.047-.538zM4.442 9.168c.02 0 .034.012.053.012h10.312V23.87H4.495c-.019 0-.034.013-.053.013V9.168zm13.326.012h11.845V23.87H17.768V9.18zm14.807 0H44.42V23.87H32.575V9.18zm14.806 0h11.846V23.87H47.38V9.18zm14.807 0h11.846V23.87H62.188V9.18zm14.807 0h10.311c.02 0 .034-.012.053-.012v14.714c-.019 0-.033-.013-.053-.013H76.995V9.18zm10.364-5.508v1.85c-.019 0-.033-.014-.053-.014H4.496c-.02 0-.035.013-.054.013V3.672H87.36zM4.442 27.528c.02 0 .034.013.053.013h82.811c.02 0 .034-.013.053-.013v1.85H4.442v-1.85zm7.403 14.702H42.94v7.344H11.845V42.23zm39.978 16.524V42.23h7.404v16.524h-7.404zm10.365 0v-18.36a2.08 2.08 0 00-.434-1.299c-.277-.344-.654-.537-1.046-.537H50.343c-.393 0-.77.193-1.047.537a2.08 2.08 0 00-.434 1.299v18.36H11.845v-5.508H44.42c.393 0 .77-.193 1.047-.538a2.08 2.08 0 00.434-1.298V40.394a2.08 2.08 0 00-.434-1.299c-.278-.344-.654-.537-1.047-.537H11.845v-5.509H65.15v25.705h-2.962z"></path>
                                            </svg>
                                            <p class="col-12"> Flat</p>
                                            <div class="col-12">
                                                <input type="radio" class="form-check-input with-gap roofPitch" id="flat-roof" value="Flat" name="roof_pitch" required>
                                                <div class="invalid-feedback mt-1">Roof pitch is required.</div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-2 mx-1 py-2">
                                        <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-radio">  
                                            <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" >
                                                <path d="M85.258 20.132a1.75 1.75 0 00-1.57-.155l-11.71 4.54L9.03.117a1.75 1.75 0 00-1.57.155 1.583 1.583 0 00-.742 1.329v7.687c0 .652.414 1.239 1.047 1.484l8.695 3.37v31.891L1.047 52.01C.414 52.254 0 52.84 0 53.492v7.688c0 .533.278 1.03.742 1.328a1.738 1.738 0 001.57.155l6.758-2.62v20.355c0 .885.752 1.602 1.68 1.602h64.5c.927 0 1.68-.717 1.68-1.602V33.742l8.023-3.11C85.586 30.387 86 29.8 86 29.148v-7.687c0-.533-.278-1.031-.742-1.329zm-75.18-11.92v-4.23l57.44 22.263-5.457 2.115L10.078 8.21zm24.86 26.382c.927 0 1.68-.717 1.68-1.602v-6.406c0-.885-.753-1.602-1.68-1.602H19.82v-9.539L57.6 30.09 19.82 44.732V34.594h15.117zM19.82 31.39v-3.203h13.438v3.203H19.82zm14.11 47.406h-21.5v-3.203h21.5v3.203zm0-6.406h-21.5v-3.204h21.5v3.204zm0-6.407h-21.5v-3.203h21.5v3.203zm0-6.406h-21.5v-.836l21.5-8.333v9.17zm32.922 19.219H56.437V62.78h10.415v16.016zm6.718 0h-3.36v-3.203h3.36v3.203zm0-25.625H61.477v-3.203H73.57v3.203zm0-6.406H60.133c-.928 0-1.68.717-1.68 1.601v6.406c0 .885.752 1.602 1.68 1.602H73.57v16.016h-3.36V61.18c0-.885-.751-1.602-1.679-1.602H54.59c-1.344 0-1.512 1.281-1.512 1.281v11.532H52.07c-.925 0-1.68.719-1.68 1.601 0 .883.755 1.602 1.68 1.602h1.008v3.203H37.29v-3.203h1.344c.925 0 1.68-.72 1.68-1.602 0-.882-.755-1.601-1.68-1.601h-1.344V56.375h13.438c.927 0 1.68-.717 1.68-1.602v-6.406c0-.884-.753-1.601-1.68-1.601h-7.399L73.57 35.044v11.722zm-36.28 6.406v-3.203h11.757v3.203H37.289zM82.64 28.07L3.36 58.8v-4.23l79.28-30.73v4.23z"></path>
                                                <path d="M61.477 72.39h.336c.927 0 1.68-.716 1.68-1.6 0-.886-.753-1.603-1.68-1.603h-.336c-.928 0-1.68.718-1.68 1.602 0 .885.752 1.602 1.68 1.602zM45.352 75.594c.925 0 1.68-.72 1.68-1.602 0-.882-.755-1.601-1.68-1.601-.926 0-1.68.719-1.68 1.601 0 .883.754 1.602 1.68 1.602z"></path>
                                            </svg>
                                            <p class="col-12"> Normal</p>
                                        <div class="col-12">
                                                <input type="radio" class="form-check-input with-gap roofPitch" id="normal-roof" value="Normal" name="roof_pitch" required> 
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-2 mx-1 py-2">
                                        <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-radio" onclick="openNavSteep()">  
                                            <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" >
                                                <path d="M78.813 77.656h-2.031V69.47h.265a2.63 2.63 0 002.625-2.625v-3.61c0-.734-.203-1.453-.593-2.062L45.844 7.797a3.814 3.814 0 00-1.312-1.281v-3.47A3.05 3.05 0 0041.485 0H38.5a3.05 3.05 0 00-3.047 3.047V6.5c-.516.313-.97.75-1.313 1.281L.922 61.171a3.901 3.901 0 00-.593 2.063v3.61a2.63 2.63 0 002.625 2.625h.265v8.187H1.188a1.18 1.18 0 00-1.172 1.172c0 .64.531 1.172 1.172 1.172H78.829A1.18 1.18 0 0080 78.828c0-.64-.532-1.172-1.188-1.172zm-1.484-14.422v3.61a.263.263 0 01-.266.265h-2.594a.263.263 0 01-.265-.265v-2.828c0-.22-.063-.438-.172-.625L69.5 56.109l2.624-1.703 4.985 8c.14.25.219.532.219.828zm-24.22-39.343l-2.624 1.703-4.328-6.953 2.61-1.72 4.343 6.97zm1.235 2l4.157 6.672-2.625 1.703-4.157-6.688 2.625-1.687zm5.407 8.656l4.546 7.312-2.625 1.703-4.562-7.312 2.64-1.703zm5.78 9.297l5.344 8.578-2.624 1.703-5.344-8.578 2.625-1.703zM37.814 3.047a.7.7 0 01.703-.703h2.985a.7.7 0 01.703.703v2.89h-4.391v-2.89zM36.141 9.03a1.526 1.526 0 011.328-.734h5.047a1.56 1.56 0 011.328.734l3.672 5.89-2.61 1.72-2.905-4.657a1.18 1.18 0 00-1-.546h-2.016a1.18 1.18 0 00-1 .546l-2.906 4.657-2.61-1.72 3.672-5.89zm-24.39 45.094l-2.625-1.703 5.343-8.578 2.625 1.703-5.344 8.578zm6.578-10.578l-2.625-1.703 4.546-7.313 2.625 1.703-4.546 7.313zm5.796-9.297L21.5 32.547l4.157-6.672 2.625 1.703-4.157 6.672zm5.391-8.656l-2.625-1.703 4.344-6.985 2.61 1.719-4.329 6.969zM2.672 66.844v-3.61c0-.297.079-.578.235-.828l4.984-8 2.625 1.703-4.531 7.282c-.11.187-.172.406-.172.625v2.828a.263.263 0 01-.266.265H2.938c-.14.016-.266-.109-.266-.265zm2.891 7.094h24.531v3.718H5.563v-3.719zm26.86-17.282v-9.672c0-.015.015-.015.015-.015h15.11c.015 0 .015.015.015.015v30.672h-15.14v-21a1.18 1.18 0 00-1.173-1.172 1.18 1.18 0 00-1.171 1.172v14.938H5.547v-2.125c1.422-.016 2.594-1.188 2.594-2.61v-2.5l31.5-50.593h.703l31.5 50.578v2.5a2.61 2.61 0 002.594 2.61v2.124h-5.734a1.18 1.18 0 00-1.172 1.172c0 .64.531 1.172 1.172 1.172h5.734v3.734H49.907v-3.719h20.375a1.18 1.18 0 001.172-1.171 1.18 1.18 0 00-1.172-1.172h-20.36v-24.61a2.367 2.367 0 00-2.359-2.359h-15.11a2.367 2.367 0 00-2.359 2.36v9.671"></path>
                                                <path d="M43.75 49.313h-7.5c-.813 0-1.469.656-1.469 1.468v8.563c0 .812.657 1.468 1.469 1.468h7.5c.813 0 1.469-.656 1.469-1.468V50.78c0-.812-.657-1.468-1.469-1.468zm-.875 9.156h-5.75v-6.813h5.75v6.813zM43.75 63.797h-7.5c-.813 0-1.469.656-1.469 1.469v8.562c0 .813.657 1.469 1.469 1.469h7.5c.813 0 1.469-.656 1.469-1.469v-8.562c0-.813-.657-1.47-1.469-1.47zm-.875 9.156h-5.75v-6.812h5.75v6.812zM42.875 29.656v9.563a.067.067 0 01-.063.062h-5.64a.067.067 0 01-.063-.062v-10.86c0-.03.032-.062.063-.062h5.64c.032 0 .063.031.063.062v1.516c0 .64.531 1.172 1.172 1.172a1.18 1.18 0 001.172-1.172v-1.516a2.407 2.407 0 00-2.407-2.406h-5.64a2.407 2.407 0 00-2.406 2.406v10.86a2.407 2.407 0 002.406 2.406h5.64a2.407 2.407 0 002.407-2.406V29.64M25.516 56.484h-9.297a2.12 2.12 0 00-2.11 2.11v8.453a2.12 2.12 0 002.11 2.11h9.297a2.12 2.12 0 002.109-2.11v-8.453a2.11 2.11 0 00-2.11-2.11zm-.235 5.22h-3.234v-2.86h3.234v2.86zm-5.578-2.86v2.86H16.47v-2.86h3.234zm-3.25 5.203h3.235v2.766h-3.235v-2.766zm5.594 2.766v-2.766h3.234v2.766h-3.234zM54.64 69.156h9.297a2.12 2.12 0 002.11-2.11v-8.452a2.12 2.12 0 00-2.11-2.11h-9.296a2.12 2.12 0 00-2.11 2.11v8.453a2.1 2.1 0 002.11 2.11zm.235-5.11h3.234v2.766h-3.234v-2.765zm5.578 2.766v-2.765h3.234v2.766h-3.234zm3.25-5.109H60.47v-2.86h3.234v2.86zm-5.594-2.86v2.86h-3.234v-2.86h3.234z"></path>
                                            </svg>
                                            <p class="col-12"> Steep</p>
                                            <div class="col-12">
                                                <input type="radio" class="form-check-input with-gap roofPitch" id="steep-roof"  value="Steep" name="roof_pitch" required> 
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-2 mx-1 py-2">
                                        <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-radio">  
                                            <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" >
                                                <path d="M30 42a1.2 1.2 0 10.001 2.401 1.2 1.2 0 000-2.401z"></path>
                                                <path d="M30 45.6a2.4 2.4 0 100-4.8 2.4 2.4 0 000 4.8z"></path>
                                                <path d="M30 0C13.457 0 0 13.457 0 30s13.457 30 30 30 30-13.457 30-30S46.543 0 30 0zm0 57.6C14.782 57.6 2.4 45.218 2.4 30 2.4 14.782 14.782 2.4 30 2.4c15.218 0 27.6 12.382 27.6 27.6 0 15.218-12.382 27.6-27.6 27.6z"></path>
                                                <path d="M38.263 21.286c-.593-3.382-3.37-6.159-6.75-6.754-2.495-.437-5.01.23-6.913 1.831a8.394 8.394 0 00-3 6.437 1.2 1.2 0 002.4 0c0-1.778.783-3.454 2.146-4.596 1.382-1.16 3.144-1.625 4.953-1.306 2.405.423 4.38 2.4 4.805 4.805.456 2.602-.725 5.098-3.012 6.355C30.33 29.472 28.8 31.913 28.8 34.8v2.4a1.2 1.2 0 001.2 1.2c.663 0 1.2-.538 1.195-1.2v-2.611c0-1.79 1.069-3.447 2.852-4.43 3.15-1.733 4.845-5.3 4.216-8.873z"></path>
                                            </svg>
                                            <p class="col-12"> ?</p>
                                            <div class="col-12">
                                                <input type="radio" class="form-check-input with-gap roofPitch" id="unknown-roof"  value="unknown" name="roof_pitch" required> 
                                            </div>
                                        </div>
                                    </div>
                                    
                                </div>
                                
                                <div class="row mb-4 d-flex justify-content-center align-items-center">
                                    <div class="col-12 text-center">
                                        <h3 class="fs-4 ">*What is your roof type?<span style="font-size:30px;cursor:pointer" onclick="openRoofTypeSideNav()"> <i class="fas fa-info-circle fa-sm"></i></span></h3>
                                    </div>
                                    <div class="col-12 col-md-8">
                                        <div class="select">
                                            <select class="select-text form-control select-input" id="roof-type" name="roof_type" required>
                                                <option value="" disabled selected></option>
                                                <option value="CalPak">CalPak</option>
                                                <option value="Clay Tile">Clay Tile</option>
                                                <option value="Comp Shingle">Comp Shingle</option>
                                                <option value="Concrete Tile">Concrete Tile</option>
                                                <option value="Corrugated Metal">Corrugated Metal</option>
                                                <option value="Foam">Foam</option>
                                                <option value="Ground Mount">Ground Mount</option>
                                                <option value="Membrane">Membrane</option>
                                                <option value="Metal Shingle">Metal Shingle</option>
                                                <option value="Other">Other</option>
                                                <option value="Rolled Comp">Rolled Comp</option>
                                                <option value="Slate">Slate</option>
                                                <option value="Standing Seam Metal">Standing Seam Metal</option>
                                                <option value="Tar & Gravel">Tar & Gravel</option>
                                                <option value="Thermoplastic Polyolefin (TPO)">Thermoplastic Polyolefin (TPO)</option>
                                                <option value="Wood Shake">Wood Shake</option>
                                                <option value="Unknown">Unknown</option>
                                            </select>
                                            <span class="select-highlight"></span>
                                            <span class="select-bar"></span>
                                            <label class="select-label">Roof Type</label>
                                            <div class="invalid-feedback mt-1">Roof type is required.</div>
                                        </div>
                                       
                                    </div>
                                </div>
                            </div>

                            <div class="form-tab">
                                <h3 class="fs-3">Let's figure out how much power you use and need</h3>
                                <!-- most basic, used for Knobs demo -->
                                <div class="row mb-4 d-flex justify-content-center align-items-center my-5">
                                    <div class="col-12 text-center mb-5">
                                        <h3 class="fs-6">What's your average monthly electricity bill?</h3>
                                        <p class="lead">Slide to select</p>
                                    </div>

                                    <div class="col-12 col-md-8 row">
                                        <div class="range-slider" style='--min:25; --max:800; --step:25; --value:400; --text-value:"400";'>
                                            <input type="range" min="25" max="800" step="25" value="400" id="slide-bill" name="electric_bill" oninput="this.parentNode.style.setProperty('--value',this.value); this.parentNode.style.setProperty('--text-value', JSON.stringify(this.value))">
                                            <output></output>
                                            <div class='range-slider__progress'></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mb-4 d-flex justify-content-center align-items-center my-5">
                                    <div class="col-12 text-center">
                                        <h3 class="fs-4 ">Do you currently have or plan to buy any of the following?</h3>
                                        <p class="lead">Select all that apply</p>
                                    </div>
                                    <div class="col-12 col-md-8">
                                        <div class="row">
                                            <div class="col-12 col-md-5 mx-1 py-2">
                                                <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-check">  
                                                    <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" >
                                                    <path d="M12.1499 11.2C11.1746 12.731 10.648 14.5048 10.6299 16.32C10.6299 18.7 11.7799 23.2 16.1499 23.2H21.0699C21.5212 24.527 22.3798 25.6777 23.5232 26.4884C24.6666 27.299 26.0367 27.7283 27.4383 27.715C28.8398 27.7017 30.2015 27.2465 31.3294 26.4143C32.4572 25.5821 33.2937 24.4153 33.7199 23.08H66.6299C67.062 24.4244 67.9097 25.597 69.0508 26.4288C70.192 27.2606 71.5677 27.7088 72.9799 27.7088C74.392 27.7088 75.7677 27.2606 76.9089 26.4288C78.05 25.597 78.8977 24.4244 79.3299 23.08H84.0899C84.5581 23.0625 85.0022 22.868 85.3326 22.5358C85.663 22.2035 85.855 21.7583 85.8699 21.29V17.15C85.8772 16.7606 85.79 16.3753 85.6159 16.027C85.4417 15.6787 85.1857 15.3778 84.8699 15.15L83.6199 14.34V12.74C83.6772 12.299 83.5904 11.8513 83.3723 11.4638C83.1542 11.0763 82.8166 10.7698 82.4099 10.59C80.5199 9.75 76.1799 8.28 68.3099 7.8C65.6161 7.69941 62.9787 6.99906 60.5899 5.75L54.2599 2.55C51.6728 1.26464 48.8285 0.580923 45.9399 0.549997H37.8999C32.5452 0.531091 27.2784 1.90985 22.6199 4.55C19.9937 6.21088 16.9246 7.03396 13.8199 6.91H13.6299C12.8064 6.34417 11.9247 5.86813 10.9999 5.49C9.91008 4.95035 8.69851 4.70393 7.48451 4.77499C6.27052 4.84605 5.09597 5.23215 4.0766 5.89525C3.05722 6.55835 2.22817 7.47557 1.67113 8.55656C1.11409 9.63756 0.848267 10.845 0.899858 12.06V54.2C0.897125 55.4618 1.39237 56.6737 2.27802 57.5724C3.16366 58.4712 4.36816 58.9842 5.62986 59C6.88034 58.9766 8.0723 58.466 8.952 57.577C9.8317 56.6879 10.3297 55.4907 10.3399 54.24V46.27C10.3448 45.4703 10.6606 44.7038 11.2205 44.1327C11.7803 43.5617 12.5404 43.2308 13.3399 43.21H13.4599C14.2602 43.2282 15.0217 43.5584 15.5821 44.13C16.1425 44.7016 16.4575 45.4695 16.4599 46.27V54.2C16.4533 54.8255 16.5703 55.4461 16.8041 56.0262C17.038 56.6063 17.3842 57.1345 17.8227 57.5805C18.2613 58.0265 18.7836 58.3815 19.3597 58.6251C19.9358 58.8687 20.5544 58.9961 21.1799 59H21.2999C21.9236 58.9935 22.54 58.8641 23.1138 58.6194C23.6876 58.3746 24.2076 58.0192 24.644 57.5735C25.0805 57.1277 25.4249 56.6004 25.6575 56.0216C25.8901 55.4428 26.0065 54.8238 25.9999 54.2V46.27C26.0023 45.4695 26.3172 44.7016 26.8776 44.13C27.438 43.5584 28.1996 43.2282 28.9999 43.21H29.1199C29.9193 43.2308 30.6794 43.5617 31.2393 44.1327C31.7991 44.7038 32.1149 45.4703 32.1199 46.27V48.4C32.1243 49.0976 32.3966 49.7668 32.8805 50.2693C33.3644 50.7719 34.0229 51.0692 34.7199 51.1H37.0899L62.3399 50.88C62.5636 52.6298 63.4009 54.2435 64.7029 55.4338C66.0049 56.6241 67.687 57.3137 69.4499 57.38H72.5999C72.6459 58.0962 72.9652 58.7673 73.4919 59.2549C74.0185 59.7424 74.7122 60.0092 75.4299 60H75.6699C76.4193 59.9772 77.1314 59.6679 77.6597 59.1359C78.188 58.6039 78.4923 57.8896 78.5099 57.14V56.57H84.9999C85.2253 56.57 85.4415 56.4804 85.6009 56.321C85.7603 56.1616 85.8499 55.9454 85.8499 55.72C85.8499 55.4946 85.7603 55.2784 85.6009 55.119C85.4415 54.9595 85.2253 54.87 84.9999 54.87H78.5099V45.1H84.9999C85.2253 45.1 85.4415 45.0104 85.6009 44.851C85.7603 44.6916 85.8499 44.4754 85.8499 44.25C85.8499 44.0246 85.7603 43.8084 85.6009 43.649C85.4415 43.4896 85.2253 43.4 84.9999 43.4H78.5099V43C78.4923 42.2504 78.188 41.5361 77.6597 41.0041C77.1314 40.4721 76.4193 40.1628 75.6699 40.14H75.4299C74.7039 40.1611 74.0121 40.4529 73.4903 40.958C72.9685 41.4631 72.6545 42.1451 72.6099 42.87H69.4699C67.7076 42.8787 66.0098 43.5343 64.6991 44.7123C63.3884 45.8903 62.5559 47.5086 62.3599 49.26L37.1099 49.49H34.7499C34.5055 49.4553 34.2808 49.3365 34.1147 49.1539C33.9486 48.9714 33.8514 48.7366 33.8399 48.49V46.27C33.8452 45.0146 33.3523 43.8083 32.4692 42.916C31.5862 42.0236 30.3853 41.5179 29.1299 41.51H28.9999C28.3787 41.5139 27.7644 41.6402 27.192 41.8815C26.6197 42.1228 26.1004 42.4746 25.664 42.9166C25.2276 43.3586 24.8825 43.8822 24.6484 44.4576C24.4143 45.033 24.2959 45.6488 24.2999 46.27V54.2C24.2949 54.9997 23.9791 55.7662 23.4193 56.3373C22.8594 56.9083 22.0993 57.2392 21.2999 57.26H21.1799C20.3804 57.2392 19.6203 56.9083 19.0605 56.3373C18.5006 55.7662 18.1848 54.9997 18.1799 54.2V46.27C18.1723 45.0203 17.6765 43.823 16.7984 42.9337C15.9203 42.0444 14.7294 41.5335 13.4799 41.51H13.3599C12.1045 41.5179 10.9035 42.0236 10.0205 42.916C9.13747 43.8083 8.64454 45.0146 8.64986 46.27V54.2C8.64493 54.9997 8.32914 55.7662 7.76926 56.3373C7.20938 56.9083 6.44933 57.2392 5.64986 57.26C4.85038 57.2392 4.09033 56.9083 3.53046 56.3373C2.97058 55.7662 2.65478 54.9997 2.64986 54.2V12C2.61404 11.0761 2.8187 10.1588 3.24381 9.33782C3.66891 8.5168 4.29989 7.82022 5.075 7.31625C5.85011 6.81228 6.74278 6.51819 7.66566 6.46275C8.58854 6.40731 9.51 6.59243 10.3399 7C11.0109 7.28367 11.6595 7.61796 12.2799 8C12.216 8.17991 12.1822 8.36911 12.1799 8.56L12.1499 11.2ZM74.2899 43C74.3082 42.7017 74.4337 42.4201 74.6431 42.207C74.8526 41.9939 75.132 41.8635 75.4299 41.84H75.6699C75.9693 41.8593 76.251 41.9883 76.4613 42.2023C76.6717 42.4163 76.7957 42.7003 76.8099 43V57.16C76.7979 57.4604 76.6746 57.7457 76.4638 57.9601C76.2531 58.1745 75.97 58.3028 75.6699 58.32H75.4299C75.2785 58.32 75.1286 58.2899 74.9889 58.2313C74.8493 58.1728 74.7227 58.087 74.6166 57.9791C74.5105 57.8711 74.4269 57.743 74.3708 57.6024C74.3147 57.4618 74.2872 57.3114 74.2899 57.16V43ZM69.4699 44.57H72.4699V55.71H69.4699C68.0078 55.6486 66.6251 55.0281 65.6072 53.9767C64.5893 52.9254 64.0139 51.5233 63.9999 50.06C63.9919 48.6004 64.5634 47.1972 65.5889 46.1585C66.6145 45.1199 68.0102 44.5306 69.4699 44.52V44.57ZM27.3799 26C26.3719 26.0159 25.382 25.7315 24.5361 25.183C23.6902 24.6346 23.0267 23.8468 22.6299 22.9201C22.2331 21.9934 22.121 20.9695 22.3079 19.9789C22.4948 18.9883 22.9722 18.0756 23.6794 17.3571C24.3865 16.6387 25.2915 16.1468 26.279 15.9443C27.2666 15.7417 28.292 15.8375 29.225 16.2195C30.1579 16.6016 30.956 17.2525 31.5179 18.0896C32.0797 18.9266 32.3797 19.9119 32.3799 20.92C32.3905 21.5833 32.269 22.2421 32.0225 22.858C31.7759 23.4739 31.4093 24.0346 30.944 24.5074C30.4786 24.9802 29.9238 25.3556 29.3119 25.6119C28.7 25.8682 28.0433 26.0001 27.3799 26ZM72.9999 26C71.9919 26.0159 71.002 25.7315 70.1561 25.183C69.3102 24.6346 68.6467 23.8468 68.2499 22.9201C67.8531 21.9934 67.741 20.9695 67.9279 19.9789C68.1148 18.9883 68.5922 18.0756 69.2994 17.3571C70.0065 16.6387 70.9115 16.1468 71.899 15.9443C72.8865 15.7417 73.912 15.8375 74.845 16.2195C75.7779 16.6016 76.576 17.2525 77.1378 18.0896C77.6997 18.9266 77.9997 19.9119 77.9999 20.92C78.0105 21.5833 77.889 22.2421 77.6425 22.858C77.396 23.4739 77.0293 24.0346 76.564 24.5074C76.0986 24.9802 75.5438 25.3556 74.9319 25.6119C74.32 25.8682 73.6633 26.0001 72.9999 26ZM53.5399 4.06L59.8299 7.24L60.4699 7.55C58.8395 8.8428 56.8206 9.5475 54.7399 9.55H43.0799V2.25H45.9999C48.6174 2.27781 51.1949 2.89654 53.5399 4.06ZM41.3799 2.25V9.55H37.8999C35.9365 9.55606 34.0082 9.03025 32.3196 8.02841C30.6311 7.02656 29.2455 5.5861 28.3099 3.86C31.3957 2.79761 34.6362 2.25358 37.8999 2.25H41.3799ZM23.4699 6.05C24.5154 5.45549 25.5976 4.92777 26.7099 4.47C27.7738 6.51773 29.3805 8.23337 31.3541 9.42919C33.3277 10.625 35.5922 11.2549 37.8999 11.25H54.7399C57.5214 11.2398 60.1939 10.1665 62.2099 8.25C64.1373 8.9509 66.1608 9.35223 68.2099 9.44C75.7999 9.91 79.9299 11.3 81.6699 12.07C81.7799 12.13 81.9599 12.25 81.9199 12.45V15.22L83.9199 16.52C83.9956 16.5993 84.0534 16.6938 84.0897 16.7973C84.1259 16.9008 84.1396 17.0108 84.1299 17.12V21.24C84.1105 21.2844 84.0834 21.325 84.0499 21.36H79.6599C79.6599 21.2 79.6599 21.06 79.6599 20.9C79.6599 19.123 78.954 17.4189 77.6975 16.1624C76.441 14.9059 74.7368 14.2 72.9599 14.2C71.1829 14.2 69.4787 14.9059 68.2222 16.1624C66.9657 17.4189 66.2599 19.123 66.2599 20.9C66.2599 21.06 66.2599 21.2 66.2599 21.36H34.0499C34.0499 21.2 34.0499 21.06 34.0499 20.9C34.0499 20.0201 33.8766 19.1489 33.5399 18.336C33.2031 17.5231 32.7096 16.7845 32.0875 16.1624C31.4653 15.5402 30.7267 15.0467 29.9138 14.71C29.101 14.3733 28.2297 14.2 27.3499 14.2C26.47 14.2 25.5988 14.3733 24.7859 14.71C23.973 15.0467 23.2344 15.5402 22.6122 16.1624C21.9901 16.7845 21.4966 17.5231 21.1599 18.336C20.8232 19.1489 20.6499 20.0201 20.6499 20.9C20.6394 21.0899 20.6394 21.2801 20.6499 21.47H16.1499C12.3899 21.47 12.3299 16.47 12.3299 16.29C12.3508 14.8809 12.7404 13.5018 13.4599 12.29H18.7299C18.9553 12.29 19.1715 12.2004 19.3309 12.041C19.4903 11.8816 19.5799 11.6654 19.5799 11.44C19.5799 11.2146 19.4903 10.9984 19.3309 10.839C19.1715 10.6795 18.9553 10.59 18.7299 10.59H13.8199L13.7599 8.68C13.8018 8.66406 13.842 8.64396 13.8799 8.62C17.261 8.73667 20.6001 7.84184 23.4699 6.05Z"></path>
                                                    </svg>
                                                    <p class="col-12"> Electric Car</p>
                                                    <div class="col-12">
                                                        <input type="checkbox" class="form-check-input with-gap appliances" id="electric-car" value="Electric Car" name="appliances[]">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-5 mx-1 py-2">
                                                <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-check">  
                                                    <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" >
                                                        <path d="M38.8 33.6c0-.5-.5-.9-.9-.9l-4.4.1 2.5-3.3c.3-.4.2-1-.2-1.3-.4-.3-1-.2-1.3.2l-3.3 4.4-7.5.1 3.6-6.5 5.5-.8c.2 0 .5-.2.6-.4.1-.2.2-.4.2-.7 0-.2-.2-.5-.4-.6-.2-.1-.4-.2-.7-.2l-4.1.6 2.1-3.8c.2-.4.1-1-.4-1.2-.4-.2-1-.1-1.2.4l-2 3.9-1.7-3.8c-.1-.2-.3-.4-.5-.5-.2-.1-.5-.1-.7 0-.2.1-.4.3-.5.5-.1.2-.1.5 0 .7l2.2 5-3.6 6.5-.1-.1-3.7-6.2v-.1l2-5c.1-.2.1-.5 0-.7-.1-.2-.3-.4-.5-.5-.5-.2-1 0-1.2.5l-1.5 3.8-2.2-3.7c-.1-.2-.3-.4-.6-.4-.2-.1-.5 0-.7.1-.4.3-.6.8-.3 1.2l2.2 3.7-4.1-.5c-.3 0-.5 0-.7.2-.2.1-.3.4-.3.6-.1.5.3.9.8 1l5.5.6v.1l3.8 6.3-7.5.1-3.4-4.2c-.3-.4-.9-.5-1.3-.1-.4.3-.5.9-.1 1.3l2.5 3.2-4.4.1c-.5 0-.9.4-.9.9s.4.9.9.9l4.4-.1-2.5 3.3c-.3.4-.2 1 .2 1.3.4.3 1 .2 1.3-.2L13 35l7.5-.1-3.5 6.4-5.5.8c-.2 0-.5.2-.6.4-.1.2-.2.4-.2.7.1.5.5.8 1 .8l4.1-.6-2.1 3.8c-.2.4-.1 1 .4 1.2.4.2 1 .1 1.2-.4l2.1-3.8 1.7 3.8c.2.4.7.7 1.2.5.2-.1.4-.3.5-.5.1-.2.1-.5 0-.7l-2.2-5 3.6-6.5.1.2 3.7 6.2v.1l-2 5c-.1.2-.1.5 0 .7.1.2.3.4.5.5.5.2 1-.1 1.2-.5l1.5-3.8 2.2 3.7c.2.3.5.4.8.4.2 0 .3 0 .5-.1.4-.3.6-.8.3-1.2l-2.2-3.7 4.1.5h.1c.5 0 .8-.3.9-.8.1-.5-.3-.9-.8-1l-5.5-.6v-.1L23.8 35l7.5-.1 3.4 4.3c.2.2.4.3.7.3.2 0 .4-.1.6-.2.4-.3.5-.9.1-1.3l-2.5-3.4 4.4-.1c.4.1.8-.4.8-.9z"></path>
                                                        <path d="M75.9 35.5c2.4 0 3.6-1.4 4.6-2.6 1-1.2 1.7-2 3.2-2 .5 0 .9-.4.9-.9s-.4-.9-.9-.9c-2.4 0-3.6 1.4-4.6 2.6-1 1.2-1.7 2-3.2 2-1.4 0-2.1-.7-3.2-2-.8-.9-1.8-2.1-3.4-2.5h-.1v-5.7h.1c.7-.5 1.2-1.2 1.7-1.7 1-1.2 1.8-2 3.2-2 .5 0 .9-.4.9-.9s-.4-.9-.9-.9c-2.4 0-3.6 1.4-4.6 2.6l-.3.4V.9c0-.5-.4-.9-.9-.9H.9C.4 0 0 .4 0 .9V55c0 .5.4.9.9.9h67.4c.5 0 .9-.4.9-.9v-9.4h.1c.7-.5 1.2-1.2 1.7-1.7 1-1.2 1.8-2 3.2-2 .5 0 .9-.4.9-.9s-.4-.9-.9-.9c-2.4 0-3.6 1.4-4.6 2.6l-.3.4v-12l.2.1c.7.3 1.3.9 2 1.7.8 1.1 2 2.6 4.4 2.6zm-8.5-13.1c-.4.2-.7.2-1.1.2-1.4 0-2.1-.7-3.2-2-1-1.2-2.2-2.6-4.6-2.6-2.4 0-3.6 1.4-4.6 2.6-1 1.2-1.7 2-3.2 2-1.4 0-2.1-.7-3.2-2-1-1.2-2.2-2.6-4.6-2.6-.5 0-.9.4-.9.9s.4.9.9.9c1.4 0 2.1.7 3.2 2 1 1.2 2.2 2.6 4.6 2.6 2.4 0 3.6-1.4 4.6-2.6 1-1.2 1.7-2 3.2-2 1.4 0 2.1.7 3.2 2 1 1.2 2.2 2.6 4.6 2.6.3 0 .6 0 .9-.1h.1v4.8h-.1c-1.8.3-2.8 1.5-3.7 2.5-1 1.2-1.7 2-3.2 2-1.4 0-2.1-.7-3.2-2-1-1.2-2.2-2.6-4.6-2.6-.5 0-.9.4-.9.9s.4.9.9.9c1.4 0 2.1.7 3.2 2 1 1.2 2.2 2.6 4.6 2.6 2.4 0 3.6-1.4 4.6-2.6.8-.9 1.4-1.6 2.2-1.8h.2v13.6h-.1c-.3.1-.6.1-1 .1-1.4 0-2.1-.7-3.2-2-1-1.2-2.2-2.6-4.6-2.6-2.4 0-3.6 1.4-4.6 2.6-1 1.2-1.7 2-3.2 2-1.4 0-2.1-.7-3.2-2-1-1.2-2.2-2.6-4.6-2.6-.5 0-.9.4-.9.9s.4.9.9.9c1.4 0 2.1.7 3.2 2 1 1.2 2.2 2.6 4.6 2.6 2.4 0 3.6-1.4 4.6-2.6 1-1.2 1.7-2 3.2-2 1.4 0 2.1.7 3.2 2 1 1.2 2.2 2.6 4.6 2.6.3 0 .6 0 .9-.1h.1V54H1.8V13.7h65.6v8.7zm0-10.5H1.8V1.8h65.6v10.1z"></path>
                                                        <path d="M22.2 5.5H6.5v2.8h15.7V5.5z"></path>
                                                    </svg>
                                                <p class="col-12"> A/C</p>
                                                <div class="col-12">
                                                        <input type="checkbox" class="form-check-input with-gap appliances" id="ac" value="A/C" name="appliances[]">  
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="row">
                                            <div class="col-12 col-md-5 mx-1 py-2">
                                                <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-check">  
                                                    <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" >
                                                        <path d="M83.78 56L75.1 39.33V0H8.91v39.54L.22 56h83.56zM3.94 53.75l6.77-12.82h62.58l6.77 12.82H3.94zm7.22-51.5h61.68v36.43H11.16V2.25zM26 44.44l-3.59 6.23h40l-3.58-6.23H26zm-.5 4.64l1.79-3h30.28l1.79 3H25.5zM18 8.89V32h48V8.89H18zm46.34 21.57H19.66v-20h44.68v20z"></path>
                                                    </svg>
                                                    <p class="col-12"> Home Office</p>
                                                    <div class="col-12">
                                                        <input type="checkbox" class="form-check-input with-gap appliances" id="home-office" value="Home Office" name="appliances[]">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-5 mx-1 py-2">
                                                <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-check">  
                                                    <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" >
                                                        <path d="M48.4268 0H11.5728C10.7339 0.000992437 9.92968 0.334667 9.33652 0.927829C8.74336 1.52099 8.40968 2.32521 8.40869 3.16406V48.0469C8.4098 48.6844 8.60328 49.3068 8.96381 49.8326C9.32435 50.3584 9.83517 50.7631 10.4295 50.9939V53.5547C10.4304 54.01 10.6082 54.4471 10.9252 54.7739C11.2422 55.1007 11.6737 55.2916 12.1287 55.3064V59.1797C12.1287 59.3972 12.2151 59.6059 12.369 59.7597C12.5228 59.9136 12.7314 60 12.949 60H16.4646C16.6822 60 16.8908 59.9136 17.0447 59.7597C17.1985 59.6059 17.2849 59.3972 17.2849 59.1797V55.3064C17.74 55.2916 18.1715 55.1007 18.4885 54.7739C18.8055 54.4471 18.9832 54.01 18.9842 53.5547V51.2109H20.2774L24.7306 55.6641C24.8843 55.8179 25.0929 55.9044 25.3104 55.9045H34.691C34.9086 55.9044 35.1171 55.8179 35.2709 55.6641L39.7217 51.2109H41.0154V53.5547C41.0164 54.01 41.1941 54.4471 41.5111 54.7739C41.8281 55.1007 42.2596 55.2916 42.7146 55.3064V59.1797C42.7146 59.2874 42.7357 59.3941 42.7769 59.4937C42.8181 59.5932 42.8786 59.6837 42.9548 59.7599C43.0309 59.8361 43.1214 59.8965 43.2209 59.9377C43.3205 59.9789 43.4272 60.0001 43.5349 60H47.0506C47.1583 60.0001 47.265 59.9789 47.3646 59.9377C47.4641 59.8965 47.5546 59.8361 47.6308 59.7599C47.7069 59.6837 47.7674 59.5932 47.8086 59.4937C47.8498 59.3941 47.8709 59.2874 47.8709 59.1797V55.3064C48.3259 55.2916 48.7574 55.1007 49.0744 54.7739C49.3914 54.4471 49.5691 54.01 49.5701 53.5547V50.9939C50.1644 50.7631 50.6752 50.3584 51.0358 49.8326C51.3963 49.3068 51.5898 48.6844 51.5909 48.0469V3.16406C51.5899 2.32521 51.2562 1.52099 50.6631 0.927829C50.0699 0.334667 49.2657 0.000992437 48.4268 0V0ZM42.244 1.64062V22.9266H17.2849V1.64062H42.244ZM15.6443 58.3594H13.7693V55.3125H15.6443V58.3594ZM17.3435 53.5547C17.3435 53.5858 17.3312 53.6156 17.3092 53.6376C17.2872 53.6595 17.2574 53.6719 17.2263 53.6719H12.1873C12.1562 53.6719 12.1264 53.6595 12.1044 53.6376C12.0824 53.6156 12.0701 53.5858 12.0701 53.5547V51.2109H17.3435V53.5547ZM46.2303 58.3594H44.3553V55.3125H46.2303V58.3594ZM47.9295 53.5547C47.9295 53.5858 47.9171 53.6156 47.8952 53.6376C47.8732 53.6595 47.8434 53.6719 47.8123 53.6719H42.7732C42.7421 53.6719 42.7123 53.6595 42.6904 53.6376C42.6684 53.6156 42.656 53.5858 42.656 53.5547V51.2109H47.9295V53.5547ZM49.9503 48.0469C49.9498 48.4508 49.7891 48.838 49.5035 49.1236C49.2179 49.4092 48.8307 49.5698 48.4268 49.5703H39.3799C39.1623 49.5704 38.9536 49.6569 38.7996 49.8108L34.3465 54.2616H25.6484L21.1953 49.8108C21.0415 49.6569 20.8329 49.5704 20.6154 49.5703H11.5685C11.1646 49.5698 10.7774 49.4092 10.4919 49.1236C10.2063 48.838 10.0456 48.4508 10.0451 48.0469V3.16406C10.0456 2.76017 10.2063 2.37297 10.4919 2.08738C10.7774 1.80179 11.1646 1.64112 11.5685 1.64062H15.6401V23.7469C15.6401 23.9644 15.7265 24.1731 15.8804 24.3269C16.0342 24.4808 16.2429 24.5672 16.4604 24.5672H43.0643C43.1721 24.5672 43.2788 24.5461 43.3783 24.5049C43.4779 24.4637 43.5683 24.4032 43.6445 24.3271C43.7207 24.2509 43.7811 24.1604 43.8223 24.0609C43.8635 23.9613 43.8847 23.8546 43.8846 23.7469V1.64062H48.4268C48.8307 1.64112 49.2179 1.80179 49.5035 2.08738C49.7891 2.37297 49.9498 2.76017 49.9503 3.16406V48.0469Z"></path>
                                                        <path d="M43.0646 26.8374H16.9355C16.7182 26.8374 16.5098 26.9236 16.356 27.0772C16.2022 27.2307 16.1156 27.439 16.1152 27.6563V31.816C16.1152 31.9321 16.1398 32.0468 16.1874 32.1526C16.235 32.2585 16.3045 32.353 16.3913 32.4301L21.0826 36.5907C21.2326 36.7237 21.4263 36.7971 21.6268 36.7969H38.3734C38.5739 36.7971 38.7675 36.7237 38.9176 36.5907L43.6088 32.4315C43.6956 32.3544 43.765 32.2598 43.8126 32.154C43.8602 32.0482 43.8848 31.9334 43.8849 31.8174V27.6563C43.8847 27.439 43.7981 27.2306 43.6443 27.077C43.4905 26.9235 43.282 26.8373 43.0646 26.8374ZM42.2443 31.4485L38.0626 35.1563H21.9376L17.7554 31.4485V28.478H42.2443V31.4485Z"></path>
                                                        <path d="M38.1445 39.8987H21.8555C21.6379 39.8987 21.4293 39.9851 21.2754 40.1389C21.1216 40.2928 21.0352 40.5014 21.0352 40.719C21.0352 40.9366 21.1216 41.1452 21.2754 41.299C21.4293 41.4529 21.6379 41.5393 21.8555 41.5393H38.1445C38.3621 41.5393 38.5707 41.4529 38.7246 41.299C38.8784 41.1452 38.9648 40.9366 38.9648 40.719C38.9648 40.5014 38.8784 40.2928 38.7246 40.1389C38.5707 39.9851 38.3621 39.8987 38.1445 39.8987Z"></path>
                                                        <path d="M34.6875 44.6414H25.3125C25.0949 44.6414 24.8863 44.7278 24.7325 44.8816C24.5786 45.0355 24.4922 45.2441 24.4922 45.4617C24.4922 45.6792 24.5786 45.8879 24.7325 46.0417C24.8863 46.1956 25.0949 46.282 25.3125 46.282H34.6875C34.9051 46.282 35.1137 46.1956 35.2675 46.0417C35.4214 45.8879 35.5078 45.6792 35.5078 45.4617C35.5078 45.2441 35.4214 45.0355 35.2675 44.8816C35.1137 44.7278 34.9051 44.6414 34.6875 44.6414Z"></path>
                                                    </svg>
                                                <p class="col-12"> H20 Heater</p>
                                                <div class="col-12">
                                                        <input type="checkbox" class="form-check-input with-gap appliances" id="h20-heater" value="H20 Heater" name="appliances[]"> 
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-12 col-md-5 mx-1 py-2">
                                                <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-check">  
                                                    <p class="col-12"> ALL</p>
                                                    <div class="col-12">
                                                        <input type="checkbox" class="form-check-input with-gap appliances-all" id="all-app" value="All" name="appliances[]">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-5 mx-1 py-2">
                                                <div role="button" class="btn btn-outline-primary d-flex flex-column justify-content-center align-items-center row checker-box-check">  
                                                    
                                                <p class="col-12"> None</p>
                                                <div class="col-12">
                                                        <input type="checkbox" class="form-check-input with-gap appliances-none" id="none-app" value="None" name="appliances[]"> 
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <div class="row mb-4 d-flex justify-content-center align-items-center my-5">
                                    <div class="col-12 col-md-8 mx-1 py-2">
                                        <h3 class="fs-4">*What is your current household size?</h3>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio">
                                                <input type="radio" class="form-check-input with-gap household_size" id="people1" value="1-2 People" name="household" required>
                                                <label class="form-check-label" for="people1">
                                                   1 - 2 people
                                                </label>
                                            </div>
                                          
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio">
                                                <input type="radio" class="form-check-input with-gap household_size" id="people2" value="3-4 People" name="household">
                                                <label class="form-check-label" for="people2">
                                                   3 - 4 people
                                                </label>
                                            </div>
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio ">
                                                <input type="radio" class="form-check-input with-gap household_size" id="people3" value="5+ People" name="household">
                                                <label class="form-check-label" for="people3">
                                                   5+ people
                                                </label>
                                                <div class="invalid-feedback mt-1">Household size is required.</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mb-4 d-flex justify-content-center align-items-center my-5">
                                    <div class="col-12 col-md-8 mx-1 py-2">
                                        <h3 class="fs-4">*Life happens. In the next year, your household size will:</h3>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio">
                                                <input type="radio" class="form-check-input with-gap household_change" id="increase1" name="household_size_next" value="Increase" required>
                                                <label class="form-check-label" for="increase1">
                                                   Increase by 1 - 2 people
                                                </label>
                                            </div>
                                          
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio ">
                                                <input type="radio" class="form-check-input with-gap household_change" id="decrease1" name="household_size_next" value="Decrease">
                                                <label class="form-check-label" for="decrease1">
                                                    Decrease by 1 - 2 people
                                                </label>
                                            </div>
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio ">
                                                <input type="radio" class="form-check-input with-gap household_change" id="stay1" name="household_size_next" value="Stay">
                                                <label class="form-check-label" for="stay1">
                                                   Stay the same
                                                </label>
                                                <div class="invalid-feedback mt-1">Future Household size is required.</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mb-4 d-flex justify-content-center align-items-center my-5">
                                    <div class="col-12 col-md-8 mx-1 py-2">
                                        <h3 class="fs-4">*What type of backup do you need during a blackout?<span style="font-size:30px;cursor:pointer" onclick="openBackupSideNav()"> <i class="fas fa-info-circle fa-sm"></i></span></h3>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio">
                                                <input type="radio" class="form-check-input with-gap backup_energy" id="backupessential" name="backup" value="Essential Backup" required>
                                                <label class="form-check-label" for="backupessential">
                                                   Essential backup of my home
                                                </label>
                                            </div>
                                          
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio ">
                                                <input type="radio" class="form-check-input with-gap backup_energy" id="complebackup" value="Complete Backup" name="backup">
                                                <label class="form-check-label" for="complebackup">
                                                   Complete backup of my home
                                                </label>
                                            </div>
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio ">
                                                <input type="radio" class="form-check-input with-gap backup_energy" id="unknownbackup" value="Backup Unknown" name="backup">
                                                <label class="form-check-label" for="unknownbackup">
                                                   I don't know.
                                                </label>
                                            </div>
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio ">
                                                <input type="radio" class="form-check-input with-gap backup_energy" id="notinterestedbackup" value="Uninterested in home backup" name="backup">
                                                <label class="form-check-label" for="notinterestedbackup">
                                                   I'm not interested in Battery backup
                                                </label>
                                                <div class="invalid-feedback mt-1">Household backup is required.</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="form-tab">

                                <h3 class="fs-3">Solar Pro's Payment options work for your needs</h3>
                    
                                <div class="row mb-4 d-flex justify-content-center align-items-center my-5">
                                    <div class="col-12 col-md-8 mx-1 py-2">
                                        <h3 class="fs-4">*Do you want to know more about:</h3>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio">
                                                <input type="radio" class="form-check-input with-gap lease_value" id="nodown" value="$0 Down Promotional" name="purchase" required>
                                                <label class="form-check-label" for="nodown">
                                                  $0 Down Promotional
                                                </label>
                                            </div>
                                          
                                        </div>
                                      
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio ">
                                                <input type="radio" class="form-check-input with-gap lease_value" id="withdiscount" value="Cash Deal with a 15% discount" name="purchase">
                                                <label class="form-check-label" for="withdiscount">
                                                  Cash Deal with a 15% discount
                                                </label>
                                            </div>
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio ">
                                                <input type="radio" class="form-check-input with-gap lease_value" id="discunknown" value="I don't know yet" name="purchase">
                                                <label class="form-check-label" for="discunknown">
                                                  I don't know yet
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mb-4 d-flex justify-content-center align-items-center my-5">
                                    <div class="col-12 col-md-8 mx-1 py-2">
                                        <h3 class="fs-4">*What is your credit scrore?</h3>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio">
                                                <input type="radio" class="form-check-input with-gap credit_score" id="credit650" value="650+" name="creditscore" required>
                                                <label class="form-check-label" for="credit650">
                                                   650+
                                                </label>
                                            </div>
                                          
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio ">
                                                <input type="radio" class="form-check-input with-gap credit_score" id="credit649" value="<649" name="creditscore">
                                                <label class="form-check-label" for="credit649">
                                                   < 649
                                                </label>
                                            </div>
                                        </div>
                                        <div class="btn-outline-primary d-flex flex-column justify-content-center align-items-center row mb-3">  
                                            <div class="col-12 form-check checker-box-radio ">
                                                <input type="radio" class="form-check-input with-gap credit_score" id="creditunknown" value="Credit Unknown" name="creditscore">
                                                <label class="form-check-label" for="creditunknown">
                                                  I don't know
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div style="overflow:auto;">
                            <div style="float:right;">
                                <input type="hidden" name="user_id" value="<?= $user_id?>">
                                <button class="btn btn-info btn-rounded main-button" type="button" id="prevBtn" onclick="nextPrev(-1)">Previous</button>
                                <button class="btn btn-info btn-rounded main-button" type="submit" id="nextBtn" onclick="nextPrev(1)">Next</button>
                            </div>
                            </div>

                        </form> 
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-3 offset-md-11 d-flex align-items-center hide-on-small-screen position-fixed start-0 top-50 translate-middle">
                <div class="container-fluid">
                    <div class="step step-active">
                        <div>
                            <div class="circle">
                                <!-- <i class="fa fa-check"></i> -->
                                1
                            </div>
                        </div>
                        <div>
                            <div class="title">Home</div>
                            <div class="caption">Home Owner</div>
                            <div class="caption" id="address_output"></div>
                            <div class="caption" id="home_size_output"></div>
                            <div class="caption" id="home_type_output"></div>
                            <div class="caption" id="roof_pitch_output"></div>
                            <div class="caption" id="roof_type_output"></div>
                        </div>
                        </div>
                    <div class="step">
                        <div>
                            <div class="circle">2</div>
                        </div>
                        <div>
                            <div class="title">Energy</div>
                            <div class="caption" id="monthly_bill_output"></div>
                            <div class="caption" id="appliances_output"></div>
                            <div class="caption" id="household_size_output"></div>
                            <div class="caption" id="household_change_output"></div>
                            <div class="caption" id="backup_output"></div>
                        </div>
                    </div>

                    <div class="step">
                        <div>
                            <div class="circle">3</div>
                        </div>
                        <div>
                            <div class="title">Payment</div>
                            <div class="caption" id="lease_output"></div>
                            <div class="caption" id="credit_score_output"></div>
                        </div>
                    </div>
                                        
                    <div class="step">
                        <div>
                            <div class="circle">4</div>
                        </div>
                        <div>
                            <div class="title">Finish</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- SideNavs -->
    <div id="RenterSideNav" class="sidenav">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h1>Sorry, we don’t currently serve renters.</h1>
                    <p class="lead">We're excited that you're enthusiastic about solar.</p>
                    
                </div>
                <div class="col-8">
                    <a href="<?=base_url()?>" type="button" class="btn btn-info btn-rounded main-button fs-6">
						Go Back to Homepage
					</a>
                </div>
            </div>
        </div>
       
    </div>

    <div id="solarpanelsidenav" class="sidenav">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h1>Sorry, we don't currently provide retrofits to existing solar installations.</h1>
                    <p class="lead">We're excited that you're enthusiastic about solar.</p>
                    
                </div>
                <div class="col-8">
                    <a href="<?=base_url()?>" type="button" class="btn btn-info btn-rounded main-button fs-6">
						Go Back to Homepage
					</a>
                </div>
            </div>
        </div>
       
    </div>

    <div id="SteepSideNav" class="sidenav">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h1>Sorry, we don’t currently support steep roofs.</h1>
                    <p class="lead">We're excited that you're enthusiastic about solar.</p>
                    
                </div>
                <div class="col-8">
                    <a href="<?=base_url()?>" type="button" class="btn btn-info btn-rounded main-button fs-6">
						Go Back to Homepage
					</a>
                </div>
            </div>
        </div>
       
    </div>

    <div id="RoofPitchSideNav" class="sidenav bg-dark-blue text-white">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <a href="javascript:void(0)" class="closebtn" onclick="closeRoofPitchSideNav()">&times;</a>
                </div>
                <div class="col-12">
                    <h1>What is roof pitch?</h1>
                </div>

                <div class="col-lg-6 col-12">
                    <h6>Flat roof</h6>
                    <p class="lead">Your roof is flat like a table top. You could probably have a party up there — yeah.</p>
                </div>
                <div class="col-6 iconhide">
                    <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" aria-hidden="true" style="fill:white;" >
                        <path d="M84.398 58.754H68.111V33.05h20.73c.392 0 .769-.193 1.046-.537.278-.345.434-.812.434-1.299V1.836c0-.487-.156-.954-.434-1.298C89.61.193 89.233 0 88.84 0H2.961c-.392 0-.769.193-1.047.538a2.08 2.08 0 00-.433 1.298v29.377c0 .487.156.954.433 1.299.278.344.655.537 1.047.537h5.923v25.705H1.481c-.393 0-.77.194-1.047.538A2.08 2.08 0 000 60.59c0 .487.156.954.434 1.299.277.344.654.537 1.047.537h82.917c.393 0 .77-.193 1.047-.537a2.08 2.08 0 00.434-1.299c0-.487-.156-.954-.434-1.298-.277-.344-.654-.538-1.047-.538zM4.442 9.168c.02 0 .034.012.053.012h10.312V23.87H4.495c-.019 0-.034.013-.053.013V9.168zm13.326.012h11.845V23.87H17.768V9.18zm14.807 0H44.42V23.87H32.575V9.18zm14.806 0h11.846V23.87H47.38V9.18zm14.807 0h11.846V23.87H62.188V9.18zm14.807 0h10.311c.02 0 .034-.012.053-.012v14.714c-.019 0-.033-.013-.053-.013H76.995V9.18zm10.364-5.508v1.85c-.019 0-.033-.014-.053-.014H4.496c-.02 0-.035.013-.054.013V3.672H87.36zM4.442 27.528c.02 0 .034.013.053.013h82.811c.02 0 .034-.013.053-.013v1.85H4.442v-1.85zm7.403 14.702H42.94v7.344H11.845V42.23zm39.978 16.524V42.23h7.404v16.524h-7.404zm10.365 0v-18.36a2.08 2.08 0 00-.434-1.299c-.277-.344-.654-.537-1.046-.537H50.343c-.393 0-.77.193-1.047.537a2.08 2.08 0 00-.434 1.299v18.36H11.845v-5.508H44.42c.393 0 .77-.193 1.047-.538a2.08 2.08 0 00.434-1.298V40.394a2.08 2.08 0 00-.434-1.299c-.278-.344-.654-.537-1.047-.537H11.845v-5.509H65.15v25.705h-2.962z"></path>
                    </svg>
                </div>

                <div class="col-lg-6 col-12">
                    <h6>Normal</h6>
                    <p class="lead">Most residential roofs have this type of roof. The slope is less than 45 degress.</p>
                </div>
                <div class="col-6 iconhide">
                    <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" style="fill:white;">
                        <path d="M85.258 20.132a1.75 1.75 0 00-1.57-.155l-11.71 4.54L9.03.117a1.75 1.75 0 00-1.57.155 1.583 1.583 0 00-.742 1.329v7.687c0 .652.414 1.239 1.047 1.484l8.695 3.37v31.891L1.047 52.01C.414 52.254 0 52.84 0 53.492v7.688c0 .533.278 1.03.742 1.328a1.738 1.738 0 001.57.155l6.758-2.62v20.355c0 .885.752 1.602 1.68 1.602h64.5c.927 0 1.68-.717 1.68-1.602V33.742l8.023-3.11C85.586 30.387 86 29.8 86 29.148v-7.687c0-.533-.278-1.031-.742-1.329zm-75.18-11.92v-4.23l57.44 22.263-5.457 2.115L10.078 8.21zm24.86 26.382c.927 0 1.68-.717 1.68-1.602v-6.406c0-.885-.753-1.602-1.68-1.602H19.82v-9.539L57.6 30.09 19.82 44.732V34.594h15.117zM19.82 31.39v-3.203h13.438v3.203H19.82zm14.11 47.406h-21.5v-3.203h21.5v3.203zm0-6.406h-21.5v-3.204h21.5v3.204zm0-6.407h-21.5v-3.203h21.5v3.203zm0-6.406h-21.5v-.836l21.5-8.333v9.17zm32.922 19.219H56.437V62.78h10.415v16.016zm6.718 0h-3.36v-3.203h3.36v3.203zm0-25.625H61.477v-3.203H73.57v3.203zm0-6.406H60.133c-.928 0-1.68.717-1.68 1.601v6.406c0 .885.752 1.602 1.68 1.602H73.57v16.016h-3.36V61.18c0-.885-.751-1.602-1.679-1.602H54.59c-1.344 0-1.512 1.281-1.512 1.281v11.532H52.07c-.925 0-1.68.719-1.68 1.601 0 .883.755 1.602 1.68 1.602h1.008v3.203H37.29v-3.203h1.344c.925 0 1.68-.72 1.68-1.602 0-.882-.755-1.601-1.68-1.601h-1.344V56.375h13.438c.927 0 1.68-.717 1.68-1.602v-6.406c0-.884-.753-1.601-1.68-1.601h-7.399L73.57 35.044v11.722zm-36.28 6.406v-3.203h11.757v3.203H37.289zM82.64 28.07L3.36 58.8v-4.23l79.28-30.73v4.23z"></path>
                        <path d="M61.477 72.39h.336c.927 0 1.68-.716 1.68-1.6 0-.886-.753-1.603-1.68-1.603h-.336c-.928 0-1.68.718-1.68 1.602 0 .885.752 1.602 1.68 1.602zM45.352 75.594c.925 0 1.68-.72 1.68-1.602 0-.882-.755-1.601-1.68-1.601-.926 0-1.68.719-1.68 1.601 0 .883.754 1.602 1.68 1.602z"></path>
                    </svg>
                </div>

                <div class="col-lg-6 col-12">
                    <h6>Steep</h6>
                    <p class="lead">Your roof is extremely steep, like a church steeple. These types of roofs are typical in regions that get snow.</p>
                </div>
                <div class="col-6 iconhide">
                    <svg class="w-75 h-75 col-12 py-5" focusable="false" viewBox="0 0 84 76" color="#0085FE" aria-hidden="true" style="fill:white;">
                        <path d="M78.813 77.656h-2.031V69.47h.265a2.63 2.63 0 002.625-2.625v-3.61c0-.734-.203-1.453-.593-2.062L45.844 7.797a3.814 3.814 0 00-1.312-1.281v-3.47A3.05 3.05 0 0041.485 0H38.5a3.05 3.05 0 00-3.047 3.047V6.5c-.516.313-.97.75-1.313 1.281L.922 61.171a3.901 3.901 0 00-.593 2.063v3.61a2.63 2.63 0 002.625 2.625h.265v8.187H1.188a1.18 1.18 0 00-1.172 1.172c0 .64.531 1.172 1.172 1.172H78.829A1.18 1.18 0 0080 78.828c0-.64-.532-1.172-1.188-1.172zm-1.484-14.422v3.61a.263.263 0 01-.266.265h-2.594a.263.263 0 01-.265-.265v-2.828c0-.22-.063-.438-.172-.625L69.5 56.109l2.624-1.703 4.985 8c.14.25.219.532.219.828zm-24.22-39.343l-2.624 1.703-4.328-6.953 2.61-1.72 4.343 6.97zm1.235 2l4.157 6.672-2.625 1.703-4.157-6.688 2.625-1.687zm5.407 8.656l4.546 7.312-2.625 1.703-4.562-7.312 2.64-1.703zm5.78 9.297l5.344 8.578-2.624 1.703-5.344-8.578 2.625-1.703zM37.814 3.047a.7.7 0 01.703-.703h2.985a.7.7 0 01.703.703v2.89h-4.391v-2.89zM36.141 9.03a1.526 1.526 0 011.328-.734h5.047a1.56 1.56 0 011.328.734l3.672 5.89-2.61 1.72-2.905-4.657a1.18 1.18 0 00-1-.546h-2.016a1.18 1.18 0 00-1 .546l-2.906 4.657-2.61-1.72 3.672-5.89zm-24.39 45.094l-2.625-1.703 5.343-8.578 2.625 1.703-5.344 8.578zm6.578-10.578l-2.625-1.703 4.546-7.313 2.625 1.703-4.546 7.313zm5.796-9.297L21.5 32.547l4.157-6.672 2.625 1.703-4.157 6.672zm5.391-8.656l-2.625-1.703 4.344-6.985 2.61 1.719-4.329 6.969zM2.672 66.844v-3.61c0-.297.079-.578.235-.828l4.984-8 2.625 1.703-4.531 7.282c-.11.187-.172.406-.172.625v2.828a.263.263 0 01-.266.265H2.938c-.14.016-.266-.109-.266-.265zm2.891 7.094h24.531v3.718H5.563v-3.719zm26.86-17.282v-9.672c0-.015.015-.015.015-.015h15.11c.015 0 .015.015.015.015v30.672h-15.14v-21a1.18 1.18 0 00-1.173-1.172 1.18 1.18 0 00-1.171 1.172v14.938H5.547v-2.125c1.422-.016 2.594-1.188 2.594-2.61v-2.5l31.5-50.593h.703l31.5 50.578v2.5a2.61 2.61 0 002.594 2.61v2.124h-5.734a1.18 1.18 0 00-1.172 1.172c0 .64.531 1.172 1.172 1.172h5.734v3.734H49.907v-3.719h20.375a1.18 1.18 0 001.172-1.171 1.18 1.18 0 00-1.172-1.172h-20.36v-24.61a2.367 2.367 0 00-2.359-2.359h-15.11a2.367 2.367 0 00-2.359 2.36v9.671"></path>
                        <path d="M43.75 49.313h-7.5c-.813 0-1.469.656-1.469 1.468v8.563c0 .812.657 1.468 1.469 1.468h7.5c.813 0 1.469-.656 1.469-1.468V50.78c0-.812-.657-1.468-1.469-1.468zm-.875 9.156h-5.75v-6.813h5.75v6.813zM43.75 63.797h-7.5c-.813 0-1.469.656-1.469 1.469v8.562c0 .813.657 1.469 1.469 1.469h7.5c.813 0 1.469-.656 1.469-1.469v-8.562c0-.813-.657-1.47-1.469-1.47zm-.875 9.156h-5.75v-6.812h5.75v6.812zM42.875 29.656v9.563a.067.067 0 01-.063.062h-5.64a.067.067 0 01-.063-.062v-10.86c0-.03.032-.062.063-.062h5.64c.032 0 .063.031.063.062v1.516c0 .64.531 1.172 1.172 1.172a1.18 1.18 0 001.172-1.172v-1.516a2.407 2.407 0 00-2.407-2.406h-5.64a2.407 2.407 0 00-2.406 2.406v10.86a2.407 2.407 0 002.406 2.406h5.64a2.407 2.407 0 002.407-2.406V29.64M25.516 56.484h-9.297a2.12 2.12 0 00-2.11 2.11v8.453a2.12 2.12 0 002.11 2.11h9.297a2.12 2.12 0 002.109-2.11v-8.453a2.11 2.11 0 00-2.11-2.11zm-.235 5.22h-3.234v-2.86h3.234v2.86zm-5.578-2.86v2.86H16.47v-2.86h3.234zm-3.25 5.203h3.235v2.766h-3.235v-2.766zm5.594 2.766v-2.766h3.234v2.766h-3.234zM54.64 69.156h9.297a2.12 2.12 0 002.11-2.11v-8.452a2.12 2.12 0 00-2.11-2.11h-9.296a2.12 2.12 0 00-2.11 2.11v8.453a2.1 2.1 0 002.11 2.11zm.235-5.11h3.234v2.766h-3.234v-2.765zm5.578 2.766v-2.765h3.234v2.766h-3.234zm3.25-5.109H60.47v-2.86h3.234v2.86zm-5.594-2.86v2.86h-3.234v-2.86h3.234z"></path>
                    </svg>
                </div>
            </div>
        </div>
       
    </div>

    <div id="RoofTypeSideNav" class="sidenav bg-dark-blue text-white">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <a href="javascript:void(0)" class="closebtn" onclick="closeRoofTypeSideNav()">&times;</a>
                </div>
                <div class="col-12">
                    <h1>What is roof type?</h1>
                </div>

                <div class="col-lg-6 col-12 pt-1">
                    <h6>Asphalt shingle</h6>
                    <p class="lead">One of the most widely used roofing covers in North America. Asphalt makes this material waterproof.</p>
                </div>
                <div class="col-6 iconhide pt-1">
                    <img src="/images/asphalt-shingle.4799d42f.jpg" class="w-100" />
                </div>

                <div class="col-lg-6 col-12 pt-1">
                    <h6>Slate</h6>
                    <p class="lead">Slate is a natural stone material that is very durable in most climates.</p>
                </div>
                <div class="col-6 iconhide pt-1">
                    <img src="/images/index.jpg" class="w-100" />
                </div>

                <div class="col-lg-6 col-12 pt-1">
                    <h6>Tile</h6>
                    <p class="lead">Tile roofs are widely used in areas that experience hot weather or exposure to salt air, and on Spanish style homes.</p>
                </div>
                <div class="col-6 iconhide pt-1">
                    <img src="/images/tile.jpg" class="w-100" />
                </div>
                <div class="col-lg-6 col-12 pt-1">
                    <h6>Metal</h6>
                    <p class="lead">Metal roofs can be ribbed or flat, and are seen on homes throughout North America.</p>
                </div>
                <div class="col-6 iconhide pt-1">
                    <img src="/images/metal.jpg" class="w-100" />
                </div>
            </div>
        </div>
       
    </div>

    <div id="BackupSideNav" class="sidenav bg-dark-blue text-white">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <a href="javascript:void(0)" class="closebtn" onclick="closeBackupSideNav()">&times;</a>
                </div>
                <div class="col-12">
                    <h1>Types of backup offered during a blackout</h1>
                </div>

                <div class="col-lg-6 col-12 pt-1">
                    <h6>Essential backup</h6>
                    <p class="lead">Only charge essential items that you need during a blackout. This option might look like having your electronics charged (smartphone/laptop), keep refrigerator cold, and more.</p>
                </div>
                <div class="col-6 iconhide pt-1">
                    <img src="/images/essentialbackup.png" class="w-100" />
                </div>

                <div class="col-lg-6 col-12 pt-1">
                    <h6>Complete backup</h6>
                    <p class="lead">Charge your entire home during a blackout. This option might look like having your electric vehicle charged, use your hot tub or entertainment center, and more.</p>
                </div>
                <div class="col-6 iconhide pt-1">
                    <img src="/images/complete-backup.89ce8d33.png" class="w-100" />
                </div>

            </div>
        </div>
       
    </div>
<?=$this->endSection()?>