$(document).ready(function(){
  $('.checker-box-radio').on("click",function(e){
   var radio_div = $(this).find("input[type='radio']");
   radio_div[0].checked = true;
   $('#roof_pitch_output').text($( '.roofPitch:checked' ).val());
   $('#household_size_output').text($('.household_size:checked' ).val());
   $('#household_change_output').text($('.household_change:checked' ).val());
   $('#backup_output').text($('.backup_energy:checked' ).val());
   $('#lease_output').text($('.lease_value:checked' ).val());
   $('#credit_score_output').text($('.credit_score:checked' ).val());
  });

  $('.checker-box-check').on("click",function(e){
    var checkbox_div = $(this).find("input[type='checkbox']");
    checkboxChecker(checkbox_div[0]);
  });

  $("input[type='checkbox']").on("click",function(e){
    checkboxChecker(this);
  });

  $('#address_input').on("keyup",function(event){
      $('#address_output').text(this.value);
  });

  $('#home_size').on("keyup",function(event){
    $('#home_size_output').text(this.value+' sq ft');
  });

  $('#home_type').on("change",function(event){
    $('#home_type_output').text(this.value);
  });

  $('.roofPitch').on("change",function(event){
    $('#roof_pitch_output').text($( '.roofPitch:checked' ).val());
  });

  $('#roof-type').on("change",function(event){
    $('#roof_type_output').text(this.value);
  });

  $('#slide-bill').on("input",function(event){
    $('#monthly_bill_output').text("$"+this.value);
  });

  $('.household_size').on("change",function(event){
    $('#household_size_output').text($('.household_size:checked' ).val()+" People");
  });

  $('.household_change').on("change",function(event){
    $('#household_change_output').text($('.household_change:checked' ).val());
  });

  $('.backup_energy').on("change",function(event){
    $('#backup_output').text($('.backup_energy:checked' ).val());
  });

  $('.lease_value').on("change",function(event){
    $('#lease_output').text($('.lease_value:checked' ).val());
  });

  $('.credit_score').on("change",function(event){
    $('#credit_score_output').text($('.credit_score:checked' ).val());
  });
   function checkboxChecker(element){
     var values = '';
    if(element.checked == true){
      element.checked = false;
    }else{
      element.checked = true;
    }
    if($(element).hasClass("appliances-none")){
      $('.appliances').prop('checked',false);
      $('.appliances-all').prop('checked',false);
    }
    if($(element).hasClass("appliances-all")){
      $('.appliances').prop('checked',true);
      $('.appliances-none').prop('checked',false);
    }
    $(".appliances:checked").each(function(e){
      values += $(this).val()+"</br>";
    });
    $('#appliances_output').html(values);
  }
});

var currentTab = 0; // Current tab is set to be the first tab (0)
showTab(currentTab); // Display the current tab

function showTab(n) {
  // This function will display the specified tab of the form ...
  var x = document.getElementsByClassName("form-tab");
  x[n].style.display = "block";
  // ... and fix the Previous/Next buttons:
  if (n == 0) {
    document.getElementById("prevBtn").style.display = "none";
  } else {
    document.getElementById("prevBtn").style.display = "inline";
  }
  if (n == (x.length - 1)) {
    document.getElementById("nextBtn").innerHTML = "Submit";
  } else {
    document.getElementById("nextBtn").innerHTML = "Next";
  }

  if(n == 1){
    document.getElementById("monthly_bill_output").innerHTML = "$400";
  }
  // ... and run a function that displays the correct step indicator:
  fixStepIndicator(n)
}

function nextPrev(n) {
  // This function will figure out which tab to display
  var x = document.getElementsByClassName("form-tab");
  // Exit the function if any field in the current tab is invalid:
  if (n == 1 && !validateForm()) return false;
  // Hide the current tab:
  x[currentTab].style.display = "none";
  // Increase or decrease the current tab by 1:
  currentTab = currentTab + n;
  // if you have reached the end of the form... :
  if (currentTab >= x.length) {
    //...the form gets submitted:
    document.getElementById("regForm").submit();
    return false;
  }
  // Otherwise, display the correct tab:
  showTab(currentTab);
}

function validateForm() {
  // This function deals with validation of the form fields
  var x, y, i, select, valid = true;
  x = document.getElementsByClassName("form-tab");
  y = x[currentTab].getElementsByTagName("input");
  select = x[currentTab].getElementsByTagName("select");
  // A loop that checks every input field in the current tab:
  for (i = 0; i < y.length; i++) {
    // If a field is empty...
    if (y[i].value == "") {
      // add an "invalid" class to the field:
      //y[i].className += " invalid";
      // and set the current valid status to false:
      valid = false;
    }
    
  }
  if(valid == true){
    for (i = 0; i < select.length; i++) {
      if (select[i].value == "") {
        valid = false;
      }
    }
  }
  
  if(valid == true){
    if(currentTab == 0){
      var radios = document.querySelector('.roofPitch:checked');
      if(radios == null){
        valid = false;
      }
      // valid = false;
      // var radios = document.getElementsByClassName("roofPitch");
      // for (var i = 0; i < pitch.length; i++) {
      //   if (radios[i].type === 'radio' && radios[i].checked) {
      //       valid = true; 
      //   }
      // }
    }

    if(currentTab == 1){
      var household_size = document.querySelector('.household_size:checked');
      var household_change = document.querySelector('.household_change:checked');
      var backup_energy = document.querySelector('.backup_energy:checked');
      if(valid == true && household_size == null){
        valid = false;
      }
      if(valid == true && household_change == null){
        valid = false;
      }
      if(valid == true && backup_energy == null){
        valid = false;
      }
    }
    if(currentTab == 2){
      var lease_value = document.querySelector('.lease_value:checked');
      var credit_score = document.querySelector('.credit_score:checked');
      var backup_energy = document.querySelector('.backup_energy:checked');
      if(valid == true && lease_value == null){
        valid = false;
      }
      if(valid == true && credit_score == null){
        valid = false;
      }
    }
  }
  // If the valid status is true, mark the step as finished and valid:
  if (valid) {
    document.getElementsByClassName("step")[currentTab].className += " completed";
  }
  return valid; // return the valid status
}

function fixStepIndicator(n) {
  // This function removes the "active" class of all steps...
  var i, x = document.getElementsByClassName("step");
  for (i = 0; i < x.length; i++) {
    x[i].className = x[i].className.replace(" step-active", "");
  }
  //... and adds the "active" class to the current step:
  x[n].className += " step-active";
}

// Example starter JavaScript for disabling form submissions if there are invalid fields
(() => {
  'use strict';

  // Fetch all the forms we want to apply custom Bootstrap validation styles to
  const forms = document.querySelectorAll('.needs-validation');

  // Loop over them and prevent submission
  Array.prototype.slice.call(forms).forEach((form) => {
    form.addEventListener('submit', (event) => {
      event.preventDefault();
      event.stopPropagation();
      if (!form.checkValidity()) {

      }
      form.classList.add('was-validated');
    }, false);
  });
})();

function openNav() {
  var width = window.screen.width;
  var value = "500px";
  if(width < 400){
    value = "250px"
  }
  document.getElementById("RenterSideNav").style.width = "500px";
  document.getElementById("maindiv").classList.add("disabledbutton");
}
function openNavSolar() {
  var width = window.screen.width;
  var value = "500px";
  if(width < 400){
    value = "250px"
  }
  document.getElementById("solarpanelsidenav").style.width = "500px";
  document.getElementById("maindiv").classList.add("disabledbutton");
}
function openNavSteep() {
  var width = window.screen.width;
  var value = "500px";
  if(width < 400){
    value = "250px"
  }
  document.getElementById("SteepSideNav").style.width = "500px";
  document.getElementById("maindiv").classList.add("disabledbutton");
}

function openRoofPitchSideNav() {
  
  var width = window.screen.width;
  var value = "500px";
  if(width < 400){
    value = "250px"
  }
  document.getElementById("RoofPitchSideNav").style.width = value;
}
function closeRoofPitchSideNav() {
  document.getElementById("RoofPitchSideNav").style.width = "0";
}

function openRoofTypeSideNav() {
  
  var width = window.screen.width;
  var value = "500px";
  if(width < 400){
    value = "250px"
  }
  document.getElementById("RoofTypeSideNav").style.width = value;
}
function closeRoofTypeSideNav() {
  document.getElementById("RoofTypeSideNav").style.width = "0";
}

function openBackupSideNav() {
  
  var width = window.screen.width;
  var value = "500px";
  if(width < 400){
    value = "250px"
  }
  document.getElementById("BackupSideNav").style.width = value;
}
function closeBackupSideNav() {
  document.getElementById("BackupSideNav").style.width = "0";
}